/*
 * TagEvent.cpp
 *
 *  Created on: 21.07.2011
 *      Author: stefan.detter
 */

#include "TagEvent.h"

static __init_TagEvent __init;


TagEvent::TagEvent()
{
	m_readTime = QDateTime::currentDateTime();
	m_readCount = 1;
	m_tagTypeId = 0;
}
TagEvent::TagEvent(const QString& readerId, const QString& readerName, const QString& readerLocation,
			const QString& type, const uint tagTypeId, const QString& tagId, const QByteArray& tagIdBytes)
	: m_readerId(readerId)
	, m_readerName(readerName)
	, m_readerLocation(readerLocation)
	, m_tagType(type)
	, m_tagTypeId(tagTypeId)
    , m_tagId(tagId)
    , m_visualTagId(tagId)
    , m_tagIdBytes(tagIdBytes)
{
	m_readTime = QDateTime::currentDateTime();
	m_readCount = 1;
}

TagEvent::TagEvent(const TagEvent& other)
{
	m_readerId 			= other.m_readerId;
	m_readerName		= other.m_readerName;
	m_readerLocation	= other.m_readerLocation;
	m_tagType			= other.m_tagType;
	m_tagTypeId			= other.m_tagTypeId;
	m_tagId				= other.m_tagId;
	m_tagIdBytes		= other.m_tagIdBytes;
    m_visualTagId       = other.m_visualTagId;
	m_readTime			= other.m_readTime;
	m_readCount			= other.m_readCount;
	m_informations 		= other.m_informations;
}
TagEvent::~TagEvent()
{
}
const QString& TagEvent::readerId() const
{
	return m_readerId;
}
const QString& TagEvent::readerName() const
{
	return m_readerName;
}
const QString& TagEvent::readerLocation() const
{
	return m_readerLocation;
}
const QString& TagEvent::tagType() const
{
	return m_tagType;
}
const quint32 TagEvent::tagTypeId() const
{
	return m_tagTypeId;
}
const QString& TagEvent::tagId() const
{
	return m_tagId;
}
const QByteArray& TagEvent::tagIdBytes() const
{
    return m_tagIdBytes;
}

const QString &TagEvent::visualTagId() const
{
    return m_visualTagId;
}
const QDateTime& TagEvent::readTime() const
{
	return m_readTime;
}
const quint64 TagEvent::readCount() const
{
	return m_readCount;
}
void TagEvent::addInformation(const uint infoType, const QVariant& info)
{
	m_informations.insert(infoType, info);
}
const QList<QVariant> TagEvent::getInformations() const
{
	return m_informations.values();
}
bool TagEvent::hasInformation(const uint infoType) const
{
	return m_informations.contains(infoType);
}
QVariant TagEvent::getInformation(const uint infoType) const
{
	return m_informations.value(infoType);
}

void TagEvent::increasReadCount(ulong readCount)
{
	m_readCount += readCount;
}

void TagEvent::setVisualTagId(const QString &visualTagId)
{
    m_visualTagId = visualTagId;
}



TagEventInformation::TagEventInformation(const quint32 type, const QString& typeString)
    : m_type(type)
	, m_typeString(typeString)
{
}
TagEventInformation::TagEventInformation()
	: m_type(UNKNOWN)
	, m_typeString("")
{}
TagEventInformation::TagEventInformation(const TagEventInformation& other)
{
	m_type = other.m_type;
	m_typeString = other.m_typeString;
}
TagEventInformation::~TagEventInformation()
{
}
const quint32 TagEventInformation::type() const
{
	return m_type;
}
const QString& TagEventInformation::typeString() const
{
	return m_typeString;
}


RSSI_Information::RSSI_Information(const quint8 percent)
	: TagEventInformation(id, "RSSI")
	, m_percent(percent)
{
}
RSSI_Information::RSSI_Information()
	: TagEventInformation(id, "RSSI")
	, m_percent(0)
{

}
RSSI_Information::RSSI_Information(const RSSI_Information& other)
	: TagEventInformation(other)
{
	m_percent = other.m_percent;
	m_channels = other.m_channels;
}
RSSI_Information::~RSSI_Information()
{}
quint8 RSSI_Information::percent() const
{
	return m_percent;
}
void RSSI_Information::addChannel(const QString& name, const qint32 minimum, const qint32 maximum, const qint32 value, const QString& unit)
{
	RSSI_Information::CHANNEL channel;
	channel.name 		= name;
	channel.minimum		= minimum;
	channel.maximum		= maximum;
	channel.value		= value;
	channel.unit 		= unit;

	m_channels << channel;
}
const QList<RSSI_Information::CHANNEL>& RSSI_Information::getChannels() const
{
	return m_channels;
}



MEMORY_Information::MEMORY_Information(const QString& memBankName, const quint32 memBank, const quint32 memAddr, const QByteArray& memData)
	: TagEventInformation(id, "MEMORY")
	, m_memBankName(memBankName)
	, m_memBank(memBank)
	, m_memAddr(memAddr)
	, m_memData(memData)
{
	if(m_memBankName.isEmpty())
		m_memBankName = QString::number(m_memBank);
}
MEMORY_Information::MEMORY_Information()
	: TagEventInformation(id, "MEMORY")
	, m_memBankName("")
	, m_memBank(0)
	, m_memAddr(0)
	, m_memData(QByteArray())
{}
MEMORY_Information::MEMORY_Information(const MEMORY_Information& other)
	: TagEventInformation(other)
{
	m_memBankName = other.m_memBankName;
	m_memBank = other.m_memBank;
	m_memAddr = other.m_memAddr;
	m_memData = other.m_memData;
}
MEMORY_Information::~MEMORY_Information()
{}
const QString& MEMORY_Information::memBankName() const
{
	return m_memBankName;
}
const quint32 MEMORY_Information::memBank() const
{
	return m_memBank;
}
const quint32 MEMORY_Information::memAddr() const
{
	return m_memAddr;
}
const QByteArray& MEMORY_Information::memData() const
{
	return m_memData;
}



TRIGGER_Information::TRIGGER_Information( const quint32 triggerId, const QString& triggerName)
	: TagEventInformation(id, "TRIGGER")
	, m_triggerId(triggerId)
	, m_triggerName(triggerName)
{}
TRIGGER_Information::TRIGGER_Information()
	: TagEventInformation(id, "TRIGGER")
	, m_triggerId(0)
	, m_triggerName("")
{}
TRIGGER_Information::TRIGGER_Information(const TRIGGER_Information& other)
	: TagEventInformation(other)
{
	m_triggerId = other.m_triggerId;
	m_triggerName = other.m_triggerName;
}
TRIGGER_Information::~TRIGGER_Information()
{}
const quint32 TRIGGER_Information::triggerId() const
{
	return m_triggerId;
}
const QString& 	TRIGGER_Information::triggerName() const
{
	return m_triggerName;
}


ANTENNA_Information::ANTENNA_Information( const quint32 antennaId )
	: TagEventInformation(id, "ANTENNA")
	, m_antennaId(antennaId)
{}
ANTENNA_Information::ANTENNA_Information()
	: TagEventInformation(id, "ANTENNA")
	, m_antennaId(1)
{}
ANTENNA_Information::ANTENNA_Information(const ANTENNA_Information& other)
	: TagEventInformation(other)
{
	m_antennaId = other.m_antennaId;
}
ANTENNA_Information::~ANTENNA_Information()
{}
const quint32 ANTENNA_Information::antennaId() const
{
	return m_antennaId;
}


FREQUENCY_Information::FREQUENCY_Information( const quint32 frequency )
	: TagEventInformation(id, "FREQUENCY")
	, m_frequency(frequency)
{}
FREQUENCY_Information::FREQUENCY_Information()
	: TagEventInformation(id, "FREQUENCY")
	, m_frequency(1)
{}
FREQUENCY_Information::FREQUENCY_Information(const FREQUENCY_Information& other)
	: TagEventInformation(other)
{
	m_frequency = other.m_frequency;
}
FREQUENCY_Information::~FREQUENCY_Information()
{}
const quint32 FREQUENCY_Information::frequency() const
{
	return m_frequency;
}


HANDLE_Information::HANDLE_Information( const QByteArray& handle )
	: TagEventInformation(id, "HANDLE")
	, m_handle(handle)
{}
HANDLE_Information::HANDLE_Information()
	: TagEventInformation(id, "HANDLE")
	, m_handle()
{}
HANDLE_Information::HANDLE_Information(const HANDLE_Information& other)
	: TagEventInformation(other)
{
	m_handle = other.m_handle;
}
HANDLE_Information::~HANDLE_Information()
{}
const QByteArray HANDLE_Information::handle() const
{
	return m_handle;
}


STATE_Information::STATE_Information( const quint16 state, const QString& stateName )
	: TagEventInformation(id, "STATE")
	, m_state(state)
	, m_stateName(stateName)
{}
STATE_Information::STATE_Information()
	: TagEventInformation(id, "STATE")
	, m_state(0)
	, m_stateName("")
{}
STATE_Information::STATE_Information(const STATE_Information& other)
	: TagEventInformation(other)
{
	m_state = other.m_state;
	m_stateName = other.m_stateName;
}
STATE_Information::~STATE_Information()
{}
const quint16 STATE_Information::state() const
{
	return m_state;
}
const QString& STATE_Information::stateName() const
{
	return m_stateName;
}


BATTERY_Information::BATTERY_Information( quint8 battery )
	: TagEventInformation(id, "BATTERY")
	, m_battery(battery)
{}
BATTERY_Information::BATTERY_Information()
	: TagEventInformation(id, "BATTERY")
	, m_battery()
{}
BATTERY_Information::BATTERY_Information(const BATTERY_Information& other)
	: TagEventInformation(other)
{
	m_battery = other.m_battery;
}
BATTERY_Information::~BATTERY_Information()
{}
const quint8 BATTERY_Information::battery() const
{
	return m_battery;
}


PC_Information::PC_Information( const QByteArray& pc )
	: TagEventInformation(id, "PC")
	, m_pc(pc)
{}
PC_Information::PC_Information()
	: TagEventInformation(id, "PC")
	, m_pc()
{}
PC_Information::PC_Information(const PC_Information& other)
	: TagEventInformation(other)
{
	m_pc = other.m_pc;
}
PC_Information::~PC_Information()
{}
const QByteArray PC_Information::pc() const
{
	return m_pc;
}

MESSAGEID_Information::MESSAGEID_Information( quint8 messageId )
	: TagEventInformation(id, "MESSAGE-ID")
	, m_messageId(messageId)
{}
MESSAGEID_Information::MESSAGEID_Information()
	: TagEventInformation(id, "MESSAGE-ID")
	, m_messageId()
{}
MESSAGEID_Information::MESSAGEID_Information(const MESSAGEID_Information& other)
	: TagEventInformation(other)
{
	m_messageId = other.m_messageId;
}
MESSAGEID_Information::~MESSAGEID_Information()
{}
const quint8 MESSAGEID_Information::messageId() const
{
	return m_messageId;
}

RN16_Information::RN16_Information( const QByteArray& rn16 )
    : TagEventInformation(id, "RN16")
    , m_rn16(rn16)
{}
RN16_Information::RN16_Information()
    : TagEventInformation(id, "RN16")
    , m_rn16()
{}
RN16_Information::RN16_Information(const RN16_Information& other)
    : TagEventInformation(other)
{
    m_rn16 = other.m_rn16;
}
RN16_Information::~RN16_Information()
{}
const QByteArray RN16_Information::rn16() const
{
    return m_rn16;
}


NXP_BRANDID_Information::NXP_BRANDID_Information(const QByteArray& brandId )
    : TagEventInformation(id, "BrandID")
    , m_nxpBrandId(brandId)
{}
NXP_BRANDID_Information::NXP_BRANDID_Information()
    : TagEventInformation(id, "BrandID")
    , m_nxpBrandId()
{}
NXP_BRANDID_Information::NXP_BRANDID_Information(const NXP_BRANDID_Information& other)
    : TagEventInformation(other)
{
    m_nxpBrandId = other.m_nxpBrandId;
}
NXP_BRANDID_Information::~NXP_BRANDID_Information()
{}
const QByteArray NXP_BRANDID_Information::brandId() const
{
    return m_nxpBrandId;
}


GENERIC_Information::GENERIC_Information( const uint infoId, const QString description, const QString value )
	: TagEventInformation(id, "GENERIC-INFO")
	, m_infoId(infoId)
	, m_description(description)
	, m_value(value)
{}
GENERIC_Information::GENERIC_Information()
	: TagEventInformation(id, "GENERIC-INFO")
	, m_infoId(0)
	, m_description("")
	, m_value("")
{}
GENERIC_Information::GENERIC_Information(const GENERIC_Information& other)
	: TagEventInformation(other)
{
	m_infoId = other.m_infoId;
	m_description = other.m_description;
	m_value = other.m_value;
}
GENERIC_Information::~GENERIC_Information()
{}
const uint GENERIC_Information::infoId() const
{
	return m_infoId;
}
const QString GENERIC_Information::description() const
{
	return m_description;
}
const QString GENERIC_Information::value() const
{
	return m_value;
}



QDataStream & operator<< (QDataStream& stream, const TagEvent& event)
{
	stream << event.m_readerId;
	stream << event.m_readerName;
	stream << event.m_readerLocation;

	stream << event.m_readTime;
	stream << event.m_readCount;

	stream << event.m_tagType;
	stream << event.m_tagTypeId;
	stream << event.m_tagId;
	stream << event.m_tagIdBytes;

	stream << event.m_informations;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, TagEvent& event)
{
	stream >> event.m_readerId;
	stream >> event.m_readerName;
	stream >> event.m_readerLocation;

	stream >> event.m_readTime;
	stream >> event.m_readCount;

	stream >> event.m_tagType;
	stream >> event.m_tagTypeId;
	stream >> event.m_tagId;
	stream >> event.m_tagIdBytes;

	stream >> event.m_informations;

	return stream;
}

QDataStream & operator<< (QDataStream& stream, const RSSI_Information& info)
{
	stream << info.m_type;
	stream << info.m_typeString;
	stream << info.m_percent;
	stream << info.m_channels;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, RSSI_Information& info)
{
	stream >> info.m_type;
	stream >> info.m_typeString;
	stream >> info.m_percent;
	stream >> info.m_channels;

	return stream;
}
QDataStream & operator<< (QDataStream& stream, const RSSI_Information::CHANNEL& channel)
{
	stream << channel.name;
	stream << channel.minimum;
	stream << channel.maximum;
	stream << channel.value;
	stream << channel.unit;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, RSSI_Information::CHANNEL& channel)
{
	stream >> channel.name;
	stream >> channel.minimum;
	stream >> channel.maximum;
	stream >> channel.value;
	stream >> channel.unit;

	return stream;
}

QDataStream & operator<< (QDataStream& stream, const MEMORY_Information& info)
{
	stream << info.m_type;
	stream << info.m_typeString;
	stream << info.m_memBankName;
	stream << info.m_memBank;
	stream << info.m_memAddr;
	stream << info.m_memData;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, MEMORY_Information& info)
{
	stream >> info.m_type;
	stream >> info.m_typeString;
	stream >> info.m_memBankName;
	stream >> info.m_memBank;
	stream >> info.m_memAddr;
	stream >> info.m_memData;

	return stream;
}

QDataStream & operator<< (QDataStream& stream, const TRIGGER_Information& info)
{
	stream << info.m_type;
	stream << info.m_typeString;
	stream << info.m_triggerId;
	stream << info.m_triggerName;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, TRIGGER_Information& info)
{
	stream >> info.m_type;
	stream >> info.m_typeString;
	stream >> info.m_triggerId;
	stream >> info.m_triggerName;

	return stream;
}

QDataStream & operator<< (QDataStream& stream, const ANTENNA_Information& info)
{
	stream << info.m_type;
	stream << info.m_typeString;
	stream << info.m_antennaId;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, ANTENNA_Information& info)
{
	stream >> info.m_type;
	stream >> info.m_typeString;
	stream >> info.m_antennaId;

	return stream;
}

QDataStream & operator<< (QDataStream& stream, const FREQUENCY_Information& info)
{
	stream << info.m_type;
	stream << info.m_typeString;
	stream << info.m_frequency;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, FREQUENCY_Information& info)
{
	stream >> info.m_type;
	stream >> info.m_typeString;
	stream >> info.m_frequency;

	return stream;
}

QDataStream & operator<< (QDataStream& stream, const HANDLE_Information& info)
{
	stream << info.m_type;
	stream << info.m_typeString;
	stream << info.m_handle;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, HANDLE_Information& info)
{
	stream >> info.m_type;
	stream >> info.m_typeString;
	stream >> info.m_handle;

	return stream;
}

QDataStream & operator<< (QDataStream& stream, const STATE_Information& info)
{
	stream << info.m_type;
	stream << info.m_typeString;
	stream << info.m_state;
	stream << info.m_stateName;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, STATE_Information& info)
{
	stream >> info.m_type;
	stream >> info.m_typeString;
	stream >> info.m_state;
	stream >> info.m_stateName;

	return stream;
}


QDataStream & operator<< (QDataStream& stream, const BATTERY_Information& info)
{
	stream << info.m_type;
	stream << info.m_typeString;
	stream << info.m_battery;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, BATTERY_Information& info)
{
	stream >> info.m_type;
	stream >> info.m_typeString;
	stream >> info.m_battery;

	return stream;
}

QDataStream & operator<< (QDataStream& stream, const PC_Information& info)
{
	stream << info.m_type;
	stream << info.m_typeString;
	stream << info.m_pc;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, PC_Information& info)
{
	stream >> info.m_type;
	stream >> info.m_typeString;
	stream >> info.m_pc;

	return stream;
}

QDataStream & operator<< (QDataStream& stream, const MESSAGEID_Information& info)
{
	stream << info.m_type;
	stream << info.m_typeString;
	stream << info.m_messageId;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, MESSAGEID_Information& info)
{
	stream >> info.m_type;
	stream >> info.m_typeString;
	stream >> info.m_messageId;

	return stream;
}

QDataStream & operator<< (QDataStream& stream, const RN16_Information& info)
{
    stream << info.m_type;
    stream << info.m_typeString;
    stream << info.m_rn16;

    return stream;
}
QDataStream & operator>> (QDataStream& stream, RN16_Information& info)
{
    stream >> info.m_type;
    stream >> info.m_typeString;
    stream >> info.m_rn16;

    return stream;
}

QDataStream & operator<< (QDataStream& stream, const NXP_BRANDID_Information& info)
{
    stream << info.m_type;
    stream << info.m_typeString;
    stream << info.m_nxpBrandId;

    return stream;
}
QDataStream & operator>> (QDataStream& stream, NXP_BRANDID_Information& info)
{
    stream >> info.m_type;
    stream >> info.m_typeString;
    stream >> info.m_nxpBrandId;

    return stream;
}

QDataStream & operator<< (QDataStream& stream, const GENERIC_Information& info)
{
	stream << info.m_type;
	stream << info.m_typeString;
	stream << info.m_infoId;
	stream << info.m_description;
	stream << info.m_value;

	return stream;
}
QDataStream & operator>> (QDataStream& stream, GENERIC_Information& info)
{
	stream >> info.m_type;
	stream >> info.m_typeString;
	stream >> info.m_infoId;
	stream >> info.m_description;
	stream >> info.m_value;

	return stream;
}

